<?php

namespace AIAssistantTenWeb;

class Library {
  public static function ai_button() {
    static $cache = null;

    if($cache === null) {
      $cache = true;
    } else {
      return;
    }
    ?>
    <div id="twai-button-cont" class="twai-button-cont twai-inline">
      <button id="twai-button" type="button" class="button button-primary button-large twai-button twai-button-disabled twai-button-green">
        <span class="twai-button-text"><?php echo esc_html__( '10Web AI', 'ai-assistant-tenweb' ); ?></span>
        <div class="twai-loader"></div>

        <div class="twai-list-container">
          <div class="twai-list-container-content">
            <div class="twai-list-header">
              <p class="twai-list-header-title"><?php echo esc_html__( 'Ask 10Web AI to:', 'ai-assistant-tenweb' ); ?></p>
            </div>
            <div class="twai-list-empty-info">
              <p><?php echo esc_html__( 'Please select a text/tittle to use AI Assistant.', 'ai-assistant-tenweb' ); ?></p>
            </div>
            <div class="twai-list-item-content">
              <div class="twai-list-item-content-layout"></div>
            <?php
            foreach ( self::actions_list() as $key => $item ) {
              ?>
              <div class="twai-list-item" data-value="<?php echo esc_attr($key); ?>">
                <span class="twai-list-item-title"><?php echo esc_html($item['title']); ?></span>
                <span class="twai-list-item-description"><?php echo esc_html($item['description']); ?></span>
              </div>
              <?php
            }
            ?>
          </div>
        </div>
      </button>
    </div>
    <?php
  }

  public static function simple_ai_button(){
    // button without action list
    static $cache = null;

    if($cache === null) {
      $cache = true;
    } else {
      return;
    }
    ?>
      <script id="twai-simple-button-template" type="text/html">
          <div class="twai-button-cont twai-simple-button-cont twai-inline">
              <button type="button"
                      class="button button-primary button-large twai-button twai-simple-button twai-button-disabled twai-button-green">
                  <span class="twai-button-text"></span>
                  <div class="twai-loader"></div>
                  <div class="twai-empty"></div>
              </button>
          </div>
      </script>
    <?php
  }

  /**
   * Notification popup template.
   *
   * @return void
   */
  public static function popup_template() {
    static $cache = null;

    if($cache === null) {
      $cache = true;
    } else {
      return;
    }

    ?>
    <div class="twai-popup-layout twai-hidden"></div>
    <div class="twai-popup-notif twai-hidden">
      <span class="twai-popup-close"></span>
      <h3 class="twai-popup-notif-title"></h3>
      <p class="twai-popup-notif-text"></p>
      <a class="twai-popup-notif-button"></a>
    </div>
    <?php
  }

  /**
   * Returns the available actions list.
   *
   * @return string[]
   */
  public static function actions_list() {
    return array(
      'outline' => array('title' => 'Generate an outline from a title', 'description' => 'Create an outline for your article based on the title.'),
      'intro' => array('title' => 'Generate an introduction from a title', 'description' => 'Compose an opening paragraph for your article.'),
      'paragraph' => array('title' => 'Generate a paragraph', 'description' => 'Create a paragraph from title or select a paragraph to prolong it.'),
      'conclusion' => array('title' => 'Generate conclusion paragraph', 'description' => 'Select a paragraph to generate a conclusion for your article.'),
      'paraphrase' => array('title' => 'Paraphrase a paragraph', 'description' => 'Rewrite the selected paragraph of your article to improve it.'),
    );
  }
}