class AIGutenbergApp {

    constructor($) {
      this.$ = $;
      this.cache = {};
    }

    cacheElements() {
      this.cache.$gutenberg = this.$( '#editor' );
      this.cache.$buttonCont = this.$( jQuery( '#gutenberg-twai-button' ).html() );
      this.cache.$button = this.cache.$buttonCont.find( '#twai-button' );
      this.cache.$action = this.cache.$buttonCont.find( '.twai-list-item' );
      this.cache.enabled = false;


      this.bindEvents();
      let self = this;
      wp.data.subscribe( function() {
        setTimeout( function() {
          self.buildPanel();
        }, 1 );
      } );
    }

    buildPanel() {
      if ( !jQuery("body").hasClass("elementor-editor-active")  ) {
        if (!this.cache.$gutenberg.find('#twai-button-cont').length) {
          this.cache.$gutenberg.find('.edit-post-header-toolbar').append(this.cache.$buttonCont);
        }
      }
    }

    bindEvents() {
      let self = this;
      this.cache.$action.on('click', function () {
        taa_button_loading(true, jQuery(this).closest(".twai-button"));
        jQuery(".twai-button-enabled").removeClass("twai-button-enabled");

        let slug = jQuery(this).data("value");
        let data = self.get_selection_data();
        let ob = new RestRequest("core/" + slug, {"prompt": data.selectionText}, "POST", function ( success ) {
          let output = success['data']['output'];
          if (slug == "outline") {
            self.add_outline_block(data.index, output);
          } else {
            self.add_paragraph_block(data.index, output);
          }
        }, function(err) {
          taa_button_loading(false);
        }, function(err) {
          taa_button_loading(false);
        });

        ob.taa_send_rest_request();
      });

      this.cache.$button.on( 'mouseenter', function() {
        self.cache.enabled = self.get_selection_data() ? true : false;
        if (self.cache.enabled) {
          self.cache.$button.removeClass("twai-button-disabled").addClass("twai-button-enabled");
        }
        else {
          self.cache.$button.removeClass("twai-button-enabled").addClass("twai-button-disabled");
        }
      } );
    }

    init() {
      this.cacheElements();
    }

    // Run flick effect on the given text.
    wordFlick (word, index, blockId, multiple, wordArray, i) {
      let self = this,
        offset = 0,
        speed = 10, // setInterval can take less than 10
        step = (word.length > 200 ? 15 : 3);

      let interval = setInterval(function () {
        if (offset >= word.length) {
          // Stop the effect on the end of the text.
          clearInterval(interval);

          if ( multiple == true ) {
            self.add_heading_block(++index, wordArray, ++i);
          }
          taa_button_loading(false);
        }
        else {
          offset += step;
          let part = word.substr(0, offset);
          // Insert the text in the block with effect.
          jQuery(blockId).removeClass("hidden").text(part);
          self.selectText(jQuery(blockId));
        }
      }, speed);
    }

    // Select the text of the given container.
    selectText(that) {
      var doc = document;
      var element = that[0];
      if (doc.body.createTextRange) {
        var range = document.body.createTextRange();
        range.moveToElementText(element);
        range.select();
      }
      else if (document.getSelection) {
        var selection = document.getSelection();
        var range = document.createRange();
        range.selectNodeContents(element);
        selection.removeAllRanges();
        selection.addRange(range);
      }
    }

    // Get selected text data ( block_id, text, index of block).
    get_selection_data() {
      let selectionData = document.getSelection();
      let selectionText = jQuery.trim(selectionData.toString());
      let blockID;
      if ( selectionText !== "" ) {
        let parentElementId = jQuery(window.getSelection().focusNode).closest("[id^='block-']");

        if ( parentElementId.length > 0 ) {
          let selectionID = parentElementId.attr("id").split("block-")[1];
          blockID = selectionID;
          let allBlocks = wp.data.select('core/block-editor').getBlocks();
          let index = allBlocks.map(function (block) {
            return block.clientId == selectionID;
          }).indexOf(true) + 1;

          if ( index == 0 ) {
            allBlocks.forEach(function (blockType, key) {
              let innerBlock = blockType.innerBlocks
              innerBlock.forEach(function (innerBlockType) {
                if (selectionID == innerBlockType.clientId) {
                  index = key + 1;
                  blockID = blockType.clientId;
                }
              });
            });
          }
          return {
            blockID: blockID,
            selectionText: selectionText,
            index: index
          };
        } else {
          return {
            blockID: 0,
            selectionText: selectionText,
            index: 0
          };
        }
      }
      return "";
    }

    // Add new paragraph block in given position.
    add_paragraph_block( index, content ) {
      // Put the generated content in temp container to make insert it with flick.
      const newBlock = wp.blocks.createBlock("core/paragraph", {
        content: content,
      });
      wp.data.dispatch("core/block-editor").insertBlocks(newBlock, index);
      jQuery("#block-" + newBlock.clientId).addClass("hidden");
      // Run the flick effect on the generated text.
      this.wordFlick(content, index, "#block-" + newBlock.clientId, false);
    }

    // Add new outline in given position.
    add_outline_block( index, content ) {
      let contentArray = content.split('\n');
      if ( contentArray.length == 1 ) {
        contentArray = content.split('•');
      }
      if ( contentArray.length == 1 ) {
        contentArray = content.split(' - ');
      }

      this.add_heading_block(index, contentArray, 0);
    }

    // Add a heading block and run an animation.
    add_heading_block (index, contentArray, i) {
      if ( typeof contentArray[i] !== "undefined" ) {
        let value = contentArray[i];
        if (value.charAt(0) === '•' || value.charAt(0) === '-') {
          value = value.substring(1);
        }
        value = value.trim();
        if (value != "") {
          const newBlock = wp.blocks.createBlock("core/heading", {
            level: 2,
            fontSize: 'x-large',
            content: value,
          });
          wp.data.dispatch("core/block-editor").insertBlocks(newBlock, index);

          jQuery("#block-" + newBlock.clientId).addClass("hidden");

          // Run the flick effect on the generated text.
          this.wordFlick(value, index, "#block-" + newBlock.clientId, true, contentArray, i);
        }
      }
    }

  }

jQuery(function($) {
  let ob = new AIGutenbergApp($);
  ob.init();
});
